-- create and select the database
DROP DATABASE IF EXISTS task4b;
CREATE DATABASE task4b;
USE task4b;  -- MySQL command

-- create the tables
CREATE TABLE categories (
  categoryID artistID      INT(11)        NOT NULL   AUTO_INCREMENT,
  categoryName artistName    VARCHAR(255)   NOT NULL,
  PRIMARY KEY (categoryID)
);

CREATE TABLE products (
  productID    albumID    INT(11)        NOT NULL   AUTO_INCREMENT,
  categoryID     artistID  INT(11)        NOT NULL,
  productCode   albumCode   VARCHAR(10)    NOT NULL   UNIQUE,
  productName    albumName  VARCHAR(255)   NOT NULL,
  listPrice      listPrice  DECIMAL(10,2)  NOT NULL,
  PRIMARY KEY (productID)
);

CREATE TABLE orders (
  orderID     trackID   INT(11)        NOT NULL   AUTO_INCREMENT,
  customerID    customerID INT            NOT NULL,
  orderDate     trackDate    DATETIME       NOT NULL,
  PRIMARY KEY (orderID)
);

-- insert data into the database
INSERT INTO categories VALUES
(1, 'HipHop'),
(2, 'House'),
(3, 'Rave');

INSERT INTO products VALUES
(1, 1, 'strat', 'Fender Stratocaster', '699.00'),
(2, 1, 'les_paul', 'Gibson Les Paul', '1199.00'),
(3, 1, 'sg', 'Gibson SG', '2517.00'),
(4, 1, 'fg700s', 'Yamaha FG700S', '489.99'),
(5, 1, 'washburn', 'Washburn D10S', '299.00'),
(6, 1, 'rodriguez', 'Rodriguez Caballero 11', '415.00'),
(7, 2, 'precision', 'Fender Precision', '799.99'),
(8, 2, 'hofner', 'Hofner Icon', '499.99'),
(9, 3, 'ludwig', 'Ludwig 5-piece Drum Set with Cymbals', '699.99'),
(10, 3, 'tama', 'Tama 5-Piece Drum Set with Cymbals', '799.99');

-- create the users
CREATE USER IF NOT EXISTS mgs_user@localhost 
IDENTIFIED BY 'pa55word';

CREATE USER IF NOT EXISTS mgs_tester@localhost 
IDENTIFIED BY 'pa55word';

-- grant privleges to the users
GRANT SELECT, INSERT, DELETE, UPDATE
ON * 
TO mgs_user@localhost;

GRANT SELECT 
ON products
TO mgs_tester@localhost;
